//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-1:Mathematical Procedures
//Example 3.11; Page 63
//Title: Finding the volume of gases leaving apparatus 

package Ex3_11
  model Ex3_11_a
    //parameter section
    parameter Real ba(unit = "cu ft") = 100 "Basis of calculation";
    parameter Real piC(unit = "mmHg") = 59 "Partial pressure of Cl before entering absorption apparatus";
    parameter Real pfC(unit = "mmHg") = 0.5 "Partial pressure of Cl after exiting absorption apparatus";
    parameter Real Ti(unit = "F") = 75 "Temperature before gases enter evaporator";
    parameter Real Tf(unit = "F") = 80 "Temperature after gases enter evaporator";
    parameter Real Pi(unit = "mmHg") = 740 "Pressure before gases enter evaporator";
    parameter Real Pf(unit = "mmHg") = 743 "Pressure after gases exit evaporator";
    parameter Real R(unit = "J/(mole*K)") = 8.314 "Universal gas constant";
    parameter Real c1(unit = " ") = 7.60 * 10 ^ (-3) / 1.01325 "1Pa=7.60*10^(-3)/1.01325mmHg";
    parameter Real c2(unit = " ") = 35.315 "1m^3=35.315cu ft";
    //variable section
    Real nfC(unit = "moles") "moles pf Cl exiting absorption system";
    Real niC(unit = "moles") "moles of Cl entering absorption system";
    Real ni(unit = "moles") "total initial moles";
    Real nf(unit = "moles") "total final moles";
    Real nI(unit = "moles") "moles of inert gas";
    Real V(unit = "cu ft") "Volume of gases leaving absorption apparatus";
    //equation section
  equation
    piC / c1 * (ba / c2) = niC * R * ((Ti - 32) * 5 / 9 + 273.15);
    Pi * (niC / ni) = piC;
    Pf * (nfC / nf) = pfC;
    niC + nI = ni;
    nfC + nI = nf;
    Pf / c1 * (V / c2) = nf * R * ((Tf - 32) * 5 / 9 + 273.15);
  end Ex3_11_a;
  
//Title: Finding weight of chlorine absorbed per 100 cu ft gases entering
  model Ex3_11_b
  /*Uses the value of moles of Cl from Ex3_11_a*/
  extends Ex3_11_a;
  //parameter section
  parameter Real MC(unit="g")=71 "Molar mass of chlorine";
  //variable section
  Real wC(unit="g") "weight of chlorine absorbed ";
  //equation section
  equation 
  wC=(niC-nfC)*MC "635.349g=1.4lb";
  end Ex3_11_b;





end Ex3_11;
