//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-3:Behavior of Ideal Gases
  //Example 3.2; Page 54
  //Title: Finding mass by an ideal gas using ideal gas equation
model Ex3_2
//parameter section
parameter Real P(unit="mm Hg")=15.5 "Pressure of WaterVapor";
parameter Real T(unit="C")=23 "Temperature of WaterVapor";
parameter Real v(unit="cu ft")=100 "volume of WaterVapor";
parameter Real M(unit="lb/lb-mole")=18 "Molar mass of WaterVapor";
parameter Real Psc(unit="mm Hg")=760 "Pressure of mixture at standard conditions";
parameter Real Tsc(unit="C")=0 "Temperature of mixture at standard conditions";
parameter Real Vsc(unit="cu ft")=359 "Volume of any ideal gas at standard conditions";
//variable section
Real vsc(unit="cuft") "Volume of mixture at standard conditions";
Real m(unit="lb") "mass of WaterVapor at 230cu ft, 15.5mmHg pressure and 23 degreeC temperature";
Real n(unit="lb-moles") "number of moles of watervapor present in 30lb watervapor";
//equation section
equation
vsc=v*P/Psc*(Tsc+273.15)/(T+273.15);
n=vsc/Vsc;
m=n*M;
end Ex3_2;
