//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-3:Behavior of Ideal Gases
  //Example 3.3; Page 54
  //Title: Finding Pressure of an ideal gas using ideal gas equation
model Ex3_3
//parameter section
parameter Real m(unit="lb")=10 "mass of CO2";
parameter Real T(unit="C")=30 "Temperature of CO2";
parameter Real v(unit="cu ft")=20 "volume of CO2";
parameter Real M(unit="g")=44 "Molar mass of CO2";
parameter Real c1(unit=" ")=453.592 "1lb=453.592g";
parameter Real c2(unit=" ")=35.315 "1m^3=35.315cu ft";
parameter Real c3(unit=" ")=6894.757 "1psi=6894.757Pa";
parameter Real R(unit="J/(mole*K)")=8.314 "universal gas constant";
//variable section
Real P(unit="psi") "Pressure of CO2 at 20cu ft, 10lb and 30 degreeC temperature";
Real n(unit="moles") "number of moles of CO2 present in 10lb CO2";
//equation section
equation
n=(m*c1)/M;
(P*c3)*(v/c2)=n*R*(T+273.15);
end Ex3_3;
