//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-3:Behavior of Ideal Gases
  //Example 3.4; Page 55
  //Title: Finding Temperature of an ideal gas using ideal gas equation
model Ex3_4
//parameter section
parameter Real m(unit="lb")=10 "mass of N2";
parameter Real P(unit="psi")=150 "Pressure of N2";
parameter Real v(unit="cu ft")=30 "volume of N2";
parameter Real M(unit="g")=28 "Molar mass of N2";
parameter Real c1(unit=" ")=453.592 "1lb=453.592g";
parameter Real c2(unit=" ")=35.315 "1m^3=35.315cu ft";
parameter Real c3(unit=" ")=6894.757 "1psi=6894.757Pa";
parameter Real R(unit="J/(mole*K)")=8.314 "universal gas constant";
//variable section
Real T(unit="K") "Temperature of N2 at 30cu ft, 10lb and 150 psi pressure";
Real n(unit="moles") "number of moles of N2 present in 10lb N2";
//equation section
equation
n=(m*c1)/M;
(P*c3)*(v/c2)=n*R*(T);
end Ex3_4;
