//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-3:Behavior of Ideal Gases
  //Example 3.6; Page 59
  //Title: Finding average molecular  weight of flue gas
model Ex3_6
//parameter section
  parameter Real ba(unit = "g-mole") = 1 "basis total moles";
  parameter Real vM(unit = " ") = 13.1 "Volumetric percent composition of CO2";
  parameter Real vE(unit = " ") = 7.7 "Volumetric percent composition of O2";
  parameter Real vN(unit = " ") = 79.2 "Volumetric percent composition of N2";
  parameter Real MM(unit="g")=44 "Molecular weight of CO2";
parameter Real ME(unit="g")=32 "Molecular weight of O2";
parameter Real MN(unit="g")=28 "Molecular weight of N2";
  //variable section
  Real xM(unit = "g-mole ") "mole of Methane";
  Real xE(unit = "g-mole ") "mole of Ethane";
Real mM(unit="g") "mass of Methane";
Real mE(unit="g") "mass of Ethane";
Real mN(unit="g") "mass of Nitrogen";
  Real xN(unit = "g-mole ") "mole of Nitrogen";
  Real M(unit="g") "Molar mass of solution";
   //equation section
equation
/*On assuming all 3 gases as ideal gas and all 3 are at same temp and pressure, the molar composition of all 3 gases are same as volumetric compostion by ideal gas equation as V/n is constant for all gases. Thus,*/
  xM = vM;
  xE = vE;
  xN = vN;
  mM=MM*(xM/100)*ba;
mE=ME*(xE/100)*ba;
mN=MN*(xN/100)*ba;
M=mM+mE+mN;
end Ex3_6;
