//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-3:Behavior of Ideal Gases
  //Example 3.9; Page 61

package Ex3_9
  //Title: Finding volume of gases leaving evaporator
  model Ex3_9_a
    //parameter section
    parameter Real ba(unit = "cu ft") = 100 "Basis of calculation";
    parameter Real moNi(unit = " ") = 79.2 "molal compositon of N2 initially";
    parameter Real moOi(unit = " ") = 7.2 "molal compositon of O2 initially";
    parameter Real moCi(unit = " ") = 13.6 "molal compositon of CO2 initially";
    parameter Real moNf(unit = " ") = 48.3 "molal compositon of N2 finally";
    parameter Real moOf(unit = " ") = 4.4 "molal compositon of O2 finally";
    parameter Real moCf(unit = " ") = 8.3 "molal compositon of CO2 finally";
    parameter Real moWf(unit = " ") = 39 "molal compositon of H2O finally";
    parameter Real Ti(unit = "C") = 200 "Temperature before gases enter evaporator";
    parameter Real Tf(unit = "C") = 85 "Temperature after gases enter evaporator";
    parameter Real Pi(unit = "mmHg") = 743 "Pressure before gases enter evaporator";
    parameter Real Pf(unit = "mmHg") = 740 "Pressure after gases enter evaporator";
    parameter Real R(unit = "J/(mole*K)") = 8.314 "Universal gas constant";
    parameter Real c1(unit = " ") = 7.60 * 10 ^ (-3) / 1.01325 "1Pa=7.60*10^(-3)/1.01325mmHg";
    parameter Real c2(unit = " ") = 35.315 "1m^3=35.315cu ft";
    //variable section
    Real ni(unit = "moles") "total initial moles";
    Real nf(unit = "moles") "total final moles";
    Real nN(unit = "moles") "number of moles of N2";
    Real nO(unit = "moles") "number of moles of O2";
    Real nC(unit = "moles") "number of moles of CO2";
    Real nW(unit = "moles") "number of moles of H2O";
    Real v(unit = "cu ft") "volume of gases leaving evaporator";
    //equation secrion
  equation
    Pi / c1 * (ba / c2) = ni * R * (Ti + 273.15);
    nN = ni * (moNi / 100);
    nO = ni * moOi / 100;
    nC = ni * moCi / 100;
    nf = nN * 100 / moNf;
    nW = nf * moWf / 100;
    Pf / c1 * (v / c2) = nf * R * (Tf + 273.15);
  end Ex3_9_a;

  //Title: Finding weight of water leaving evaporator
  model Ex3_9_b
  /*uses the values of moles from Ex3_9_a*/
  extends Ex3_9_a;
  //parameter section
  parameter Real MW(unit="g")=18 "Molar mass of water";
  //variable section
  Real wW(unit="g") "weight of water leavung evaporator";
  //equation section
  equation
  wW=MW*nW "820.803g=1.81lb";
  end Ex3_9_b;










end Ex3_9;
