//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-4:Vapor Pressures
//Example 4.10; Page 106
//Title: Estimating vapor presure of mixture with non-volatile solute in water at 25 degree C
model Ex4_10
//parameter section
parameter Real mw(unit="g")=1000 "mass of water";
parameter Real mos(unit="g-moles")=5 "moles of NaCl in mixture";
parameter Real MS(unit="g")=58.5 "molar mass of NaCl";
parameter Real Tb(unit="C")=106 "normal boiling point of this solution";
parameter Real Pnbm(unit="mmHg")=760 "vapor pressure of mixture at normal boiling point of mixture";
parameter Real Pnbw(unit="mmHg")=940 "vapor pressure of water at normal boiling point of mixture";
parameter Real Pw(unit="mmHg")=23.5 "vapor pressure of water at 25 degree C";
//variable section
Real ms(unit="g") "mass of NaCl in mixture";
Real k(unit=" ") "constant in modified Raoult's law used for obtaining vapor pressure at a temp if only one experimental value given";
Real Pm(unit="mmHg") "Vapor Pressure of mixture at 25 degree C";
//equation section
equation
ms=mos*MS;
k=Pnbm/Pnbw;
Pm=k*Pw "Experimentally observed value=18.97mmHg";
end Ex4_10;
