//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-4:Vapor Pressures
  //Example 4.4; Page 90
//Title: Estimating critical properties of methyl propionate  
model Ex4_4
//import section
import Modelica.Math.*;
//parameter section
parameter Real Tb(unit="K")=352 "normal boiling temperature";
parameter Real Lb(unit="kcal/g-mole")=7.718 "Latent heat of vaporization at normal boiling point";
parameter Real M(unit="g")=88.1 "Molar mass of methyl propionate";
parameter Real R(unit="J/(mole*K)")=8.314 "universal gas constant";
parameter Real dTM1(unit=" ")=0.02 "Temperature contribution of one methl group connected to one atom other than hydrogen ";
parameter Real dTM2(unit=" ")=0.02 "Temperature contribution of one methyl group connected to two atom other than hydrogen ";
parameter Real dTCOO(unit=" ")=0.047 "Temperature contribution of ester group ";
parameter Real Tcon(unit=" ")=0.567 "Temperature constant of equation";
parameter Real dpM1(unit=" ")=0.227 "pressure contribution of one methyl group connected to one atom other than hydrogen ";
parameter Real dpM2(unit=" ")=0.227 "pressure contribution of one methyl group connected to two atom other than hydrogen ";
parameter Real dpCOO(unit=" ")=0.47 "pressure contribution of chloride group ";
parameter Real Pcon(unit="(g/atm)^(0.5)")=0.34 "Pressure constant of equation";
parameter Real dvM1(unit=" ")=55 "volume contribution of one methyl group connected to one atom other than hydrogen ";
parameter Real dvM2(unit=" ")=55 "volume contribution of one methyl group connected to two atom other than hydrogen ";
parameter Real dvCOO(unit=" ")=80 "volume contribution of chloride group ";
parameter Real vcon(unit="cc")=40 "volume constant of equation";
parameter Real c1(unit="atm/Pa")=101325 "1atm=101325Pa";
parameter Real c2(unit="m^3/cc")=10^6 "1m^3=10^6cc";
//variable section
Real sdT(unit=" ") "Sum of delta T of all groups in methyl propionate";
Real sdp(unit=" ") "Sum of delta P of all groups in methyl propionate";
Real sdv(unit=" ") "Sum of delta v of all groups in methyl propionate";
Real Tc(unit="K") "critical temperature of methyl propionate";
Real Pc(unit="atm") "critical pressure of methyl propionate";
Real vc(unit="cc/g-mole") "critical volume of methyl propionate";
Real zcc(unit=" ") "critical compressibility factor calculated using critical temp, Pressure, Volume";
Real zcL(unit=" ") "critical compressibility factor calculated using critical Latent heat of vaporization";
//equation section
equation
sdT=dTM1*2+dTM2+dTCOO;
sdp=dpM1*2+dpM2+dpCOO;
sdv=dvM1*2+dvM2+dvCOO;
Tb/Tc=Tcon+sdT-sdT^2;
(M/Pc)^(0.5)=Pcon+sdp;
vc=vcon+sdv;
zcc=(Pc*c1)*(vc/c2)/(R*Tc);
zcL=1/(3.43+0.0067*Lb^2);
end Ex4_4;
