//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-4:Vapor Pressures
//Example 4.6; Page 98
//Title: Calculating temperature at which distillation of benzene will happen
package Ex4_6
        
  //Title: Finding the amount of water in 1lb benzene
  model Ex4_6_b
  /*This part uses the data in Ex4.6a which is done directly in book. The temp found out is 69 degree C having vapor pressure of benzene 520mmHg and vapor pressure of steam 225mmHg */
  //parameter section
  parameter Real pb(unit="mmHg")=520 "Vapor pressure of benzene";
  parameter Real ps(unit="mmHg")=225 "Vapor pressure of steam";
  parameter Real Mb(unit="g")=78 "Molar mass of benzene";
  parameter Real Ms(unit="g")=18 "Molar mass of steam";
  //variable section
  Real mb(unit="lb-moles") "amount of benzene in lb-moles";
  Real ms(unit="lb-moles") "amount of steam in lb-moles";
  Real wb(unit="lb") "amount of benzene";
  Real ws(unit="lb") "amount of steam";
  Real wws(unit=" ") "amount of steam per lb benzene";
  //equation section
  equation
  mb=pb/(pb+ps);
  ms=ps/(ps+pb); 
  wb=mb*Mb;
  ws=ms*Ms; 
  wws=ws/wb;
  end Ex4_6_b;

end Ex4_6;
