//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-4:Vapor Pressures
//Example 4.7; Page 99
//Title: Estimating amount of myristic acid per pound steam in distillation 
model Ex4_7
//parameter section
parameter Real vm(unit="mmHg")=0.032 "Vapor pressure of Myristic acid at 99 degree C";
parameter Real tp(unit="mmHg")=740 "total pressure at 99 degree C";
parameter Real MM(unit="g")=228 "Molar mass of myristic acid";
parameter Real MS(unit="g")=18 "molar mass of steam";
//variable section
Real mm(unit="lb-moles") "lb-moles of myristic acid";
Real ms(unit="lb-moles") "lb-moles of steam";
Real wm(unit="lb") "amount of myristic acid";
Real ws(unit="lb") "amount of steam";
Real wws(unit=" ") "amount of steam per lb myristic acid";
//equation section
equation
mm=vm/tp;
ms=1-mm;
wm=mm*MM;
ws=ms*MS;
wws=ws/wm;
end Ex4_7;
