//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-5:Humidity and Saturation
//Example 5.2; Page 113
//Title: Calculating relative saturation and percent saturation of acetone vapor and nitrogen mixture
model Ex5_2
//parameter section
parameter Real ba(unit="lb-moles")=1 "basis of calculation";
parameter Real vpa(unit=" ")=14.8 "volume percent of acetone in mixture";
parameter Real T(unit=" C")=20 "temperature of mixture";
parameter Real P(unit="mmHg")=745 "Pressure of mixture";
parameter Real va(unit="mmHg")=184.8 "Vapor pressure of pure acetone";
//variable section
Real ppa(unit="mmHg") "Partial pressure of acetone";
Real rs(unit=" ") "relative saturation of acetone";
Real na(unit="lb-moles") "number of moles of acetone";
Real nn(unit="lb-moles") "number of moles of N2";
Real nan(unit=" ") "number of moles of acetone per mole N2";
Real nas(unit="lb-moles") "number of moles of acetone if mixture is saturated";
Real nns(unit="lb-moles") "number of moles of N2 if mixture is saturated";
Real nans(unit=" ") "number of moles of acetone per mole N2 if mixture is saturated";
Real ps(unit=" ") "percent saturation";
//equation section
equation
ppa=P*(vpa/100);
rs=ppa/va*100;
na=ba*(vpa/100);
nn=ba-na;
nan=na/nn;
nas=ba*va/P;
nns=ba-nas;
nans=nas/nns;
ps=nan/nans*100;
end Ex5_2;
