package Ex5_6
//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-5:Humidity and Saturation
  //Example 5.6; Page 118
  
  //Title: Calculating molal humidity of air

  model Ex5_6_a
    //parameter section
    parameter Real T1(unit = "C") = 20 "Temperature of air";
    parameter Real P1(unit = "mmHg") = 750 "Presure of air";
    parameter Real rh(unit = " ") = 80 "relative humidity percenten of air";
    parameter Real vpw1(unit = "mmHg") = 17.5 "Vapor pressure oa water at 20 degree C";
    //variable section
    Real ppw1(unit = "mmHg") "partial pressure of water at 20 degree C";
    Real ppa1(unit = "mmHg") "partial pressure of mixture at 20 degree C";
    Real mh1(unit = "mmHg") "molal humidity of mixture at 20 degree C";
    //equation section
  equation
    ppw1 = vpw1 * (rh / 100);
    ppa1 = P1 - ppw1;
    mh1 = ppw1 / ppa1;
  end Ex5_6_a;


  //Title: Calculating molal humidity of air
  model Ex5_6_b
  parameter Real T2(unit = "C") = 10 "Temperature of air";
  parameter Real vpw2(unit = "mmHg") = 9.2 "Vapor pressure oa water at 10 degree C";
  parameter Real P2(unit="psi")=35 "Pressure of mixture";
  parameter Real c1(unit=" ")= 51.71484 "Conversion factor from psi to mmHg; 1psi= 51.71484mmHg";
  //variable section
  Real ppw2(unit = "mmHg") "partial pressure of water at 10 degree C";
    Real ppa2(unit = "mmHg") "partial pressure of mixture at 10 degree C";
    Real mh2(unit = "mmHg") "molal humidity of mixture at 10 degree C";
    //equation section
    equation
    ppw2=vpw2 "As some of the water started condensing which implies water vapor in air has reached the saturation point";
    ppa2=(P2*c1)-ppw2;
    mh2=ppw2/ppa2; 
  end Ex5_6_b;

  //Title: Calculating the amount of water condensed
  model Ex5_6_c
  extends Ex5_6_a;
  extends Ex5_6_b;
  //parameter section
  parameter Real ba(unit="cuft")=1000 "Volume of original wet air";
  parameter Real P0(unit="mmHg")=760 "Pressure at standard conditions";
  parameter Real V0(unit="cuft")=359 "Volume at standard conditions of one lb-mole gas";
  parameter Real T0(unit="K")=273.15 "Temperature at standard conditions";
  parameter Real MW(unit="g")=18 "Molar  mass of water";
  //variable section
  Real tn(unit="lb-moles") "total moles in mixture initially";
  Real nw1(unit="lb-moles") "moles of water vapor initially";
  Real nw2(unit="lb-moles") "moles of water vapor finally";
  Real na1(unit="lb-moles") "moles of dry air initially";
  Real nwc(unit="lb-moles") "moles of water vapor condensed";
  Real wwc(unit="lb") "mass of water condensed";
  //equation section
  equation
  tn=(P1/P0)*(ba/V0)*(T0/(T1+273.15));
  nw1+na1=tn;
  nw1=mh1*na1;
  nw2=mh2*na1 "number of moles of dry air remain unchanged";
  nwc=nw1-nw2;
  wwc=MW*nwc;
  end Ex5_6_c;

  //Title: Finding final volume of wet air
  model Ex5_6_d
  extends Ex5_6_c;
  //variable section
  Real Vw(unit="cuft") "final volume of wet air";
  //equation section
  equation
  Vw=(nw2+na1)*V0*((T2+273.15)/T0)*(P0/(P2*c1));
  end Ex5_6_d;







end Ex5_6;
