//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-6:Solubility and crystallization
  //Example 6.13; Page 161
  //Title: Estimating the conditions of air and dessicant 
  model Ex6_13
  //parameter section
  parameter Real aCi(unit="lb")=90 "amount of CaCl2 initially";
  parameter Real T(unit="F")=80 "Temperature of gas";
  parameter Real V(unit="cuft")=90000 "volume of container";
  parameter Real rhi(unit=" ")=90 "relative humidity initially";
  parameter Real P(unit="atm")=1 "Pressure of air inside container";
  parameter Real rhf(unit=" ")=27 "final relative humidity from graph";
  parameter Real cCsf(unit=" ")=46 "composition of CaCl2 in solution finally";
  parameter Real MC(unit="g")=111 "Molar mass of CaCl2";
  parameter Real MW(unit="g")=18 "Molar mass of H2O";
  parameter Real mWHC(unit="moles")=6 "moles of H2O in hexahydrate CaCl2 crystal";
  parameter Real pW(unit="in. Hg")=1.0321 "Vapor pressure of H2O at 80 degree F";
  parameter Real c1(unit=" ")=29.92 "1atm=29.92in.Hg";
  parameter Real c2(unit=" ")=5/9 "1Kelvin=9/5Rankine";
  parameter Real Vs(unit="cuft")=359 "volume of ideal gas in standard conditions";
  parameter Real Ps(unit="in.Hg")=29.92 "Pressure of ideal gas in standard conditions";
  parameter Real Ts(unit="R")=492 "Temperature of ideal gas in standard conditions";
  parameter Real MA(unit="g")=29 "molar mass of dry air"; 
  //variable section
  Real cCc(unit=" ") "composition of CaCl2 in hexahydrate crystal";
  Real ppwi(unit="in. Hg") "partial vapor pressure of H2O initially";
  Real ppwf(unit="in. Hg") "partial vapor pressure of H2O finally";
  Real hi(unit=" ") "humidity of air initially";
  Real hf(unit=" ") "humidity of air finally";
  Real wrd(unit="lb") "water removed per lb dry air";
  Real adf(unit="lb") "amount of dry air finally";
  Real tawr(unit="lb") "total amount of water removed finally"; 
  Real aCs(unit="lb") "amount of CaCl2.6H2O in solution";
  Real aS(unit="lb") "amount of saturated solution";
  Real x;
  //equation section
  equation
  cCc=MC/(MC+mWHC*MW);
  ppwi=(rhi/100)*pW;
  ppwf=(rhf/100)*pW;
  hi=ppwi/(c1*P-ppwi)*MW/MA;
  hf=ppwf/(c1*P-ppwf)*MW/MA;  
  wrd=hi-hf;
  adf=(V/Vs)*((P*c1-ppwf)/Ps)*(Ts/((((T-32)*5/9)+273.15)*9/5))*MA;
  tawr=adf*wrd;
  x=MC/(MC+mWHC*MW);
  aCi=MC/(MC+mWHC*MW)*aCs+(cCsf/100)*(aCi+tawr-aCs) "error >2% due to approximation in book";
  aS=aCi+tawr-aCs;
  end Ex6_13;
