//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-6:Solubility and crystallization
  //Example 6.2; Page 145
  //Title:Finding the amount of solution requuired to dissolve 250lb CaCl2.6H20 
  model Ex6_2
  //parameter section
  parameter Real ba(unit="lb")=100 "Amount of water in solution as basis";
  parameter Real mC(unit="lb")=62 "Amount of CaCl2 in 100 lb water";
  parameter Real aCd(unit="lb")=250 "Amount of CaCl2.6H20 to dissolve";
  parameter Real sC(unit="lb-moles")=7.38 "amount of CaCl2 soluble in 1000lb water at 25 degree C";
  parameter Real MC(unit="g")=111 "Molar mass of CaCl2";
  parameter Real MW(unit="g")=18 "Molar mass of H20";
  //variable section
  Real ace(unit="lb") "Amount of CaCl2 entering solution";
  Real acex(unit="lb") "Amount of CaCl2 exiting solution";
  Real ww(unit="lb") "weight of water in solution required to dissolve 250 lb CaCl2.6H20";
  Real ws(unit="lb") "amount of solution required";
  //equation section
  equation
  ace=(aCd/(MC+6*MW))*MC+(mC/100)*ww;
  acex=(sC*MC/1000)*(ww+(aCd/(MC+6*MW))*6*MW);
  ace=acex;
  ws=ww+(mC/100)*ww;
end Ex6_2;
