//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-6:Solubility and crystallization
  //Example 6.5; Page 148
  //Title: Finding percentage yield of K2Cr2O7 crystals
model Ex6_5
//parameter section
parameter Real ba(unit="lb")=1000 "amount of solution as basis";
parameter Real wpK(unit=" ")=13 "weight % of K2Cr2O7 in solution";
parameter Real we(unit="lb")=640 "amount of water evaporated";
parameter Real sK2(unit="lb-moles")=0.39 "solubility of K2Cr2O7 per 1000lb H2O at 20 degree C";
parameter Real MK(unit="g")=294 "Molar mass of K2Cr2O7";
//variable section
Real wr(unit="lb") "amount of water remaining";
Real aK1(unit="lb") "amount of K2Cr2O7 in solution initially";
Real aK2(unit="lb") "maximum amount of K2Cr2O7 that can be present in solution finally";
Real d1(unit="lb") "dummy variable";
Real aKc(unit="lb" ) "amount of K2Cr2O7 crystallized";
Real py(unit=" ") "percentage yield of K2Cr2O7 crystals";
//equation section
equation
wr=ba*(1-wpK/100)-we;
aK1=(wpK/100)*ba;
aK2=(sK2*MK/1000)*wr;
d1=aK1-aK2;
if d1<=0 then
aKc=0;
else
aKc=d1;
end if;
py=(aKc/aK1)*100;
end Ex6_5;
