package Ex7_3
  //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-7:Material Balances
  //Example 7.3; Page 200

  model Ex7_3_a
    //Title: Finding weight of lime charged per 100lb causticized mass
    //parameter section
    parameter Real ba(unit = "lb") = 100 "amount of causticized mass";
    parameter Real pCcs(unit = " ") = 13.48 "percent of CaCO3 in causticized solution";
    parameter Real pCHs(unit = " ") = 0.28 "percent of Ca(OH)2 in causticized solution";
    parameter Real pNCs(unit = " ") = 0.61 "percent of Na2CO3 in causticized solution";
    parameter Real pNHs(unit = " ") = 10.36 "percent of NaOH in causticized solution";
    parameter Real pHs(unit = " ") = 75.27 "percent of H2O in causticized solution";
    parameter Real pNHal(unit = " ") = 0.594 "percent of NaOH in alkaline liqour";
    parameter Real pNCal(unit = " ") = 14.88 "percent of Na2CO3 in alkaline liqour";
    parameter Real pHal(unit = " ") = 84.53 "percent of H2O in alkaline liqour";
    parameter Real MN(unit = "g") = 23 "Molar mass of Na";
    parameter Real MO(unit = "g") = 16 "Atomic mass of 1 mole O";
    parameter Real MH(unit = "g") = 1 "Atomic mass of 1 mole H";
    parameter Real MC(unit = "g") = 12 "Atomic mass of 1 mole C";
    parameter Real MCa(unit = "g") = 40 "Molar mass of Ca";
    //variable section
    Real aNcs(unit = "lb") "amount of Na atoms in causticized solution";
    Real aNal(unit = "lb") "amount of Na atoms in 1lb alkaline liqour";
    Real aal(unit = "lb") "amount of alkaline liqour";
    Real aCcs(unit = "lb") "amount of Ca atoms in causticized solution";
    Real pCHa(unit = "lb") "percent of slaked lime in partly slaked lime added";
    Real pCCa(unit = "lb") "percent of CaCO3 in partly slaked lime added";
    Real pCOa(unit = "lb") "percent of CaO in partly slaked lime added";
    Real m(unit = "lb") "mass of slaked lime added";
    //equation section
  equation
    aNcs = pNCs / 100 * ba * (2 * MN / (2 * MN + MC + 3 * MO)) + pNHs / 100 * ba * (MN / (MN + MO + MH)) "Sodium balance in causticized solution";
    aNal = pNHal / 100 * (MN / (MN + MO + MH)) + pNCal / 100 * (2 * MN / (2 * MN + MC + 3 * MO)) "sodium balance in sodium liqour";
    aal = aNcs / aNal;
    aCcs = pCcs / 100 * ba * (MCa / (MCa + MC + 3 * MO)) + pCHs / 100 * ba * (MCa / (MCa + 2 * (MO + MH))) "Calcium balance";
    pCHa + pCCa + pCOa = 100;
    m + aal = ba;
    pCcs / 100 * ba * (MC / (MCa + MC + 3 * MO)) + pNCs / 100 * ba * (MC / (2 * MN + MC + 3 * MO)) = pCCa / 100 * m * (MC / (MC + MCa + 3 * MO)) + aal * (pNCal / 100) * (MC / (2 * MN + MC + 3 * MO)) "Carbon balance";
    pCHs / 100 * ba * (2 * MH / (MCa + 2 * (MO + MH))) + pNHs / 100 * ba * (MH / (MN + MO + MH)) + pHs / 100 * ba * (2 * MH / (2 * MH + MO)) = pCHa / 100 * m * (2 * MH / (MCa + 2 * (MO + MH))) + pNHal / 100 * aal * (MH / (MN + MO + MH)) + pHal / 100 * aal * (2 * MH / (2 * MH + MO)) "Hydrogen balance";
  end Ex7_3_a;


 


  model Ex7_3_b
  extends Ex7_3_a;
  //variable section
  Real asln(unit="lb") "amount of partly slaked lime required";
  //equation section
  equation
  asln=aal;
  end Ex7_3_b;

  model Ex7_3_c
  extends Ex7_3_a;
  //parameter section
  parameter Real nNC(unit="lb-moles")=1 "no. of moles of Na2CO3 required per mole CaO";
  //varaible section
  Real aCOm(unit="lb-moles") "Amount of CaO as reactant in lb-moles";
  Real aNCm(unit="lb-moles") "amount of Na2CO3 as reactant in lb-moles";
  Real per(unit=" ") "percent excess excess reagent";
  //equation section
  equation
  aCOm=(pCOa/100)*m/(MCa+MO)+(pCHa/100)*m/(MCa+2*(MO+MH));
  aNCm=(pNCal/100)*aal/(2*MN+MC+3*MO);
  if nNC*aCOm<aNCm then
  per=(aNCm-nNC*aCOm)/(nNC*aCOm)*100;
  else
  per=(-1)*(aNCm-nNC*aCOm)/aNCm*100;
  end if;
  end Ex7_3_c;

  model Ex7_3_d
  extends Ex7_3_c;
  //variable section
  Real aCHm(unit="lb-moles") "amount of Ca(OH)2 in causticized solution"; 
  Real dc(unit=" ") "degree of completion of reaction";
  //equation section
  equation
  aCHm=(pCHs/100)*ba/(MCa+2*(MO+MH));
  dc=(aCOm-aCHm)/aCOm*100;
  end Ex7_3_d;












end Ex7_3;
