//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-7:Material Balances
  //Example 7.8; Page 222
  //Title: Estimating the fraction of recycle that must be continually purged
model Ex7_8
//parameter section
parameter Real ba(unit="lb-moles")=100 "amount of N2-H2 in fresh feed";
parameter Real pc(unit=" ")=25 "percentage conversion to ammonia";
parameter Real aAf(unit="lb-moles") "amount of argono in fresh feed";
parameter Real pAer(unit=" ")=5 "percent of argon entering reactor in feed";
parameter Real Ae(unit="lb-moles")=0.2 "amount of argon entering per 100lb-mole N2, H2 mixture"; 
//variable section
Real NHr(unit="lb-moles") "moles of N2 and H2 recycled to reactor";
Real NHp(unit="lb-moles") "moles of N2 and H2 purged";
Real mNHer(unit="lb-moles") "amount of N2 and H2 entering reactor";
Real mNHlr(unit="lb-moles") "amount of N2 and H2 leaving reactor";
Real mNHf(unit="lb-moles") "amount of NH3 formed";
Real aAtf(unit="lb-moles") "amount of argon in total feed";
Real aAlpNH(unit=" ") "amount of argon leaving condensor per mole N2, H2 mixture";
Real aAp(unit="lb-moles") "amount of Argon purged off";
Real rr(unit=" ") "recycle ratio";
Real pr(unit=" ") "purge ratio";
//equation section
equation
mNHer=ba+NHr;
mNHlr=(1-pc/100)*mNHer;
mNHf=pc/100*mNHer/2 "divided by 2 because 4 mole of feed forms 2 moles of NH3";
aAtf=pAer/100*mNHer;
aAlpNH=pAer/(100-pc);
aAp=aAlpNH*NHp;
aAp=Ae/100*ba "amount of Argon in fresh feed is equal to the amount of argon purged in steady state";
mNHlr=NHr+NHp "balance of N2, H2 mixture";
rr=NHr/ba;
pr=NHp/NHr;
end Ex7_8;
