//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-8: Thermophysics
  //Example 8.2; Page 275
  //Title: Estimating molal heat of vaporization of acetone
model Ex8_2
//parameter section
parameter Real P1(unit="atm")=1 "1st pressure of acetone";
parameter Real P2(unit="atm")=8 "2nd pressure of acetone";
parameter Real Tb1(unit="K")=329.7 "Boiling point of acetone at 1 atm";
parameter Real Tb2(unit="K")=406.3 "Boiling point of acetone at 8 atm";
parameter Real Pc(unit="atm")=46.6 "critical pressure of acetone";
parameter Real Tc(unit="K")=508.7 "critical temperature of acetone";
parameter Real A(unit=" ")=3.0644 "Vapor pressure constant";
parameter Real b(unit=" ")=0.18 "Vapor pressure constant";
parameter Real R(unit="cal/(g-mole*K)")=1.987 "universal gas constant";
//variable section
Real Tr1(unit=" ") "reduced temperature at 1 atm pressure";
Real Tr2(unit=" ") "reduced temperature at 8 atm pressure";
Real Pr1(unit=" ") "reduced pressure at 1 atm pressure";
Real Pr2(unit=" ") "reduced pressure at 8 atm pressure";
Real Hv1(unit="cal/g-mole") "Heat of vaporization at 1atm";
Real Hv2(unit="cal/g-mole") "Heat of vaporization at 8atm";
//equation section
equation
Tr1=Tb1/Tc;
Tr2=Tb2/Tc;
Pr1=P1/Pc;
Pr2=P2/Pc;
/* zg-zl=0.966 at reduced pressure and temperature corresponding to 1 atm pressure
zg-zl=0.822 at reduced pressure and temperature corresponding to 8 atm pressure 
 */
Hv1=2.303*0.966*R*Tc*(A+40*Tr1^2*(Tr1-b)*exp(-20*(Tr1-b)^2)) "Experimental value of Heat of vaporization at 1atm=7231 cal/g-mole";
Hv2=2.303*0.822*R*Tc*(A+40*Tr2^2*(Tr2-b)*exp(-20*(Tr2-b)^2)) ;
end Ex8_2;
