//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-9:Thermochemistry
  //Example 9.11; Page 328
  //Title: calculating temperature of solutiona nd weight of water evaporated
model Ex9_11
//parameter section
parameter Real apH(unit="lb")=1 "amount of pure H2SO4 at 150 degree F";
parameter Real asH(unit="lb")=1 "amount of 20% H2SO4 solution";
parameter Real cH(unit=" ")=20 "concentration of H2SO4 solution";
parameter Real EpH(unit="Btu/lb")=40 "Enthalpy of H2SO4 at 150 degree F";
parameter Real EsH(unit="Btu/lb")=76 "Enthalpy of 20% solution of H2SO4 at 200 degree F";
parameter Real Ewv(unit="Btu/lb")=1194 "Enthalpy of water vapor at 300 degree F";
parameter Real Es2H(unit="Btu/lb")=1 "Enthalpy of 6% H2SO4 solution at 300 degree F";
//variable section
Real fc(unit=" ") "final concentration of vapor+solution";
Real awe(unit="lb") "amount of water vapor evaporated";
//equation section
equation
fc=(apH+asH*cH/100)/(apH+asH)*100;
/*The final temperature corresponding to this concentration is 300 degree F from graph. the concentration of solution corresponding to these conditions of solution is 63% H2SO4 solution.*/
EpH+EsH=Ewv*awe+Es2H*(apH+asH-awe) "Energy balance";
end Ex9_11;
