//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-9:Thermochemistry
  //Example 9.14; Page 340
  //Title: calculating heat evolved on adding oleum
model Ex9_14
//parameter section
parameter Real ba(unit="lb")=100 "amount of weak acid used";
parameter Real cWa(unit=" ")=19 "percent SO3 in weak acid";
parameter Real cO(unit=" ")=89.2 "percent SO3 in oleum";
parameter Real cSa(unit=" ")=65.6 "percent SO3 in strong acid";
parameter Real pESwa(unit="Btu/lb-mole")=-67.1*10^3 "partial enthalpy of SO3 in weak acid";
parameter Real pESsa(unit="Btu/lb-mole")=-35.82*10^3 "partial enthalpy of SO3 in strong acid";
parameter Real pESo(unit="Btu/lb-mole")=-4.68*10^3 "partial enthalpy of SO3 in oleum";
parameter Real pEWwa(unit="Btu/lb-mole")=-0.14*10^3 "partial enthalpy of water in weak acid";
parameter Real pEWsa(unit="Btu/lb-mole")=-7.16*10^3 "partial enthalpy of water in strong acid";
parameter Real pEWo(unit="Btu/lb-mole")=-35.10*10^3 "partial enthalpy of water in oleum";
parameter Real MS(unit="g")=80 "Molar mass of SO3";
parameter Real MW(unit="g")=18 "Molar mass of H2O";

//variable section
Real aSa(unit="lb") "amount of strong acid";
Real aO(unit="lb") "amount of oleum";
Real aSSa(unit="lb") "amount of SO3 in Strong acid";
Real aSWa(unit="lb") "amount of SO3 in Weak acid";
Real aSO(unit="lb") "amount of SO3 in Oleum";
Real aWSa(unit="lb") "amount of water in Strong acid";
Real aWWa(unit="lb") "amount of water in Weak acid";
Real aWO(unit="lb") "amount of water in Oleum";
Real He(unit="Btu") "amount of heat evolved per 100 lb weak acid";
//equation section
equation
aSa=aO+ba;
cSa/100*aSa=cO/100*aO+cWa/100*ba;
aSSa=aSa*cSa/100;
aSWa=ba*cWa/100;
aSO=aO*cO/100;
aWSa=aSa*(1-cSa/100);
aWWa=ba*(1-cWa/100);
aWO=aO*(1-cO/100);
He+aSWa*pESwa/MS+aSO*pESo/MS+aWWa*pEWwa/MW+aWO*pEWo/MW=aSSa*pESsa/MS+aWSa*pEWsa/MW;
end Ex9_14;
