//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-9:Thermochemistry
  //Example 9.19; Page 352
  //Title: Calculating the temperature of gases leaving convertor
  /*Reactions:4FeS2+11O2-->2Fe2O3+8SO2
              SO2+0.5O2-->SO3 */
model Ex9_19
//parameter section
parameter Real ba(unit="g-moles")=4 "amount of FeS2 as basis";
parameter Real peO(unit=" ")=100 "percent excess oxygen";
parameter Real aOA(unit=" ")=0.21 "fraction of oxygen in air";
parameter Real pC(unit=" ")=80 "percent conversion of SO2 to SO3";
parameter Real HcSO2(unit="g-cal/(g-mole*K)")=10.94 "Mean molal Heat capacity of SO2 entering convertor";
parameter Real HcO2(unit="g-cal/(g-mole*K)")=7.406 "Mean molal Heat capacity of O2 entering convertor";
parameter Real HcN2(unit="g-cal/(g-mole*K)")=7.089 "Mean molal Heat capacity of N2 entering convertor";
parameter Real Te(unit="C")=400 "Temperature of entering convertor";
parameter Real Tr(unit="C")=25 "standard Temperature";
parameter Real HfSO2(unit="cal/g-mole")=-70960 "Heat of formation of SO2";
parameter Real HfSO3(unit="cal/g-mole")=-94450 "Heat of formation of SO3";

//variable section
Real aOs(unit="g-moles") "amount of O2 supplied";
Real aOr(unit="g-moles") "amount of O2 required";
Real aAs(unit="g-moles") "amount of air supplied";
Real aNs(unit="g-moles") "amount of N2 supplied";
Real eO(unit="g-moles") "amount of excess O2 in burner gas";
Real aSb(unit="g-moles") "amount of SO2 in burner gas";
Real aSf(unit="g-moles") "amount of SO3 formed in convertor";
Real aOc(unit="g-moles") "amount of Oxygen consumed in convertor";
Real aSl(unit="g-moles") "amount of SO2 leaving convertor";
Real aSOl(unit="g-moles") "amount of SO3 leaving convertor";
Real aOl(unit="g-moles") "amount of Oxygen leaving convertor";
Real aNl(unit="g-moles") "amount of Nitrogen leaving convertor";
Real He(unit="cal") "enthalpy of gases entering";
Real SHr(unit="cal") "standard heat of reaction";
Real T(unit="K") "temperature of gases leaving convertor";
Real HO(unit="cal") "Enthalpy of oxygen";
Real HN(unit="cal") "Enthalpy of nitrogen";
Real HSO2(unit="cal") "Enthalpy of SO2";
Real HSO3(unit="cal") "Enthalpy of SO3";
Real Hp(unit="cal") "Enthalpy of products";
//equation section
equation
aOr=11;
aOs=aOr*(1+peO/100);
aAs=aOs/aOA;
aNs=aAs-aOs;
eO=aOs-aOr;
aSb=8;
aSf=aSb*pC/100;
aOc=aSf/2;
aSl=aSb*(1-pC/100);
aSOl=aSf;
aOl=eO-aOc;
aNl=aNs;
He=aSb*HcSO2*(Te-Tr)+eO*HcO2*(Te-Tr)+aNs*HcN2*(Te-Tr);
SHr=aSf*(HfSO3-HfSO2);
HO=47.7*(T-298)+0.01236*(T^2-298^2)-2.612*10^(-6)*(T^3-298^3);
HN=535*(T-298)+0.0575*(T^2-298^2)-1.904*10^(-6)*(T^3-298^3);
HSO2=11.1*(T-298)+0.00801*(T^2-298^2)-2.022*10^(-6)*(T^3-298^3);
HSO3=47.6*(T-298)+0.0612*(T^2-298^2)-14.14*10^(-6)*(T^3-298^3);
Hp=HO+HN+HSO2+HSO3;
Hp=He-SHr;
end Ex9_19;
