 //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-9:Thermochemistry
  //Example 9.3; Page 312
  //Title: Finding the standard heat of reaction of: 2FeS2(s)+5.5O2(g)=Fe2O3(s)+4SO2(g)
model Ex9_3
//parameter section
parameter Real HFS(unit="cal")=-42520 "heat of formation of FeS2(s)";
parameter Real HO(unit="cal")=0 "heat of formation of O2(g)";
parameter Real HFO(unit="cal")=-196500 "heat of formation of Fe2O3(s)";
parameter Real HS(unit="cal")=-70960 "heat of formation of SO2(g)";
//variable section
Real SH(unit="cal") "Standard heat of reaction";
//equation section
equation
SH=4*HS+HFO-5.5*HO-2*HFS;
end Ex9_3;
