model Ex22_1
//m^3l - m^3 of liquid, m^3r - m^3 of reactor
  Real CA(unit = "mol/m^3l")"Concentration of A", Mt, rA(unit = "mol/m^3r.s"), XB"Conversion of B", eps, Vr(unit = "m^3")"Volume of reactor", FB0(unit = "mol/s")"initial flowrte of B";
  parameter Real n = 0.5, L = (5 * 10^(-3)) / 6, Lc(unit = "m") = 5"Length of the column", k(unit = "(m^3l/kg cat.s)*(mol/m^3l)^0.5") = 2.35e-3"Reaction rate constant", rhos(unit = "kg/m^3 cat") = 4500"density of solids", De(unit = "m^3l/m cat.s") = 8e-10"Diffusion coeff", PA(unit = "Pa") = 101325"Pressure in pascal", HA(unit = "Pa.m^3 l/mol") = 36845, PAatm(unit = "atm") = 1"Pressure in atmosphere", kAiai(unit = "m^3 l / m^3 r.s") = 0.02, kAcac(unit = "m^3 l/ m^3 r.s") = 0.05, fs = 0.6, A(unit = "m^2") = 0.1"Cross section area of column", CB0(unit = "mol/m^3 l") = 100"initial concentration of B", vt(unit = "m^3 l/s") = 10e-4"volumetric flowrate of liquid";
  
  equation
    CA = PA / HA;
    Mt = L * (((n + 1) / 2) * (k * CA^(n - 1) * rhos / De))^0.5;
    eps = 1 / Mt;
    rA = 1/((1 / kAiai) + (1 / kAcac) +(1 / (k * CA^(-0.5) * eps * fs * rhos))) * (PA / HA);
    FB0 * XB = rA * Vr;
    Vr = A * Lc;
    FB0 = CB0 * vt;
end Ex22_1;
