model Ex23_1
  Real MH"Hatta Number", E, rA(unit = "mol/hr.m^3 reactor")"rate of conversion of A", Rg"Resistantce in gas film", Rl"Resistance in liquid film", Rmb"Resistance in main body", xRg"fraction of resistance in gas film", xRl"fraction of resistance in liquid film", xRmb"fraction of resistance in main body";
  parameter Real PA(unit = "Pa") = 5e3"Pressure", CB(unit = "mol/m^3") = 100"Concentration of B", DA(unit = "m^2/hr") = 10^(-6)"diffusion coeff", kAga(unit = "mol/hr.m^3.Pa") = 0.01, fl = 0.98, HA(unit = "Pa.m^3/mol") = 10^5, a(unit = "m^2/m^3") = 20, kAl = 1, k(unit = "m^6/mol^2.hr") = 10^6;
  
  equation
    MH = (DA * k * CB^2)^0.5 / kAl;
    E = MH;
    rA = PA /(Rg + Rl + Rmb) ;
    Rg = 1 / (kAga);
    Rl = HA / (kAl * a * E);
    Rmb = HA / (k * CB^2 * fl);
    xRg = Rg / (Rg + Rl + Rmb);
    xRl = Rl / (Rg + Rl + Rmb);
    xRmb = Rmb / (Rg + Rl + Rmb);
end Ex23_1;
