model Ex24_1
  Real CA2(unit = "mol/m^3")"Concentration of A", h(unit = "m")"Height of tower", rG(unit = "%")"percentage of error in gas film", rL(unit = "%")"percentage of error in liquid film", KAga"KAg * a", pAmpAs"pA - pA*";
  parameter Real FlbAcs(unit = "mol/hr.m^2") = 7e5, pi = 1e5, FgbAcs(unit = "mol/hr.m^2") = 1e5, CT(unit = "mol/m^3") = 56000, pA1 = 20, pA2 = 100, CA1 = 0, kAga(unit = "mol/pr.m^3.Pa") = 0.32, kAla(unit = "hr") = 0.1, HA(unit = "Pa.m^3/mol") = 12.5;
  
  equation
    pA2 - pA1 = ((FlbAcs * pi) / ((FgbAcs) * CT)) * (CA2 - CA1);
    (1 / KAga) = (1 / kAga) + (HA / kAla);
    rG = (1 / kAga) * 100/ ((1 / kAga) + (HA / kAla));
    rL = (HA / kAla) * 100/ ((1 / kAga) + (HA / kAla));
    pAmpAs = 20;
    h = (FgbAcs / (pi * KAga))* ((pA2 - pA1) / (pAmpAs));
end Ex24_1;