model Ex24_2
//simulate from 20 to 100
  Real CB2(unit = "mol/m^3")"Final concentration of B", rA"rate of consumption of A", h(unit = "m")"Height of Tower", PA(unit = "Pa");
  parameter Real pA(unit = "Pa") = 20, kAg = 0.32, kl = 0.1, CB1(unit = "mol/m^3") = 800"initial concentration of B", FgbAcs = 1e5, pi = 1e5, FlbAcs = 7e5, CT = 56000, PA1(unit = "Pa") = 20"Initial pressure of A", PA2(unit = "Pa") = 100"final pressure of A", a = 1"stoichiometric coeff of A", b = 1"Stoichiometric coeff of B";
  
  equation
   PA2 - PA1 =((FlbAcs * pi) / (FgbAcs * b * CT)) * (CB1 - CB2);
   rA = kAg * a * PA;
   der(h)/ der(PA) = (FgbAcs / pi) * (1 / (rA));  
   PA = time;
end Ex24_2;
