model Ex24_6
  Real MH1"Hatta Number", Ei1, MH2"Hatta Number", Ei2, rA1(unit = "mol/m^3.hr")"rate of formation of A", rA2(unit = "mol/m^3.hr")"rate of formation of A", rA(unit = "mol/m^3.hr")"avg rate of formation of A", t(unit = "hr"), tmin(unit = "hr"), fract(unit = "%");
  parameter Real DB(unit = "m^2/hr") = 3.6e-6"Diffusion coeff", k(unit = "m^3/mol.hr") = 2.6e5, CB0(unit = "mol/m^3") = 555.6"initial concentration of B", kAl(unit = "m/hr") = 1.44, HA(unit = "Pa.m^3/mol") = 1000, pAi(unit = "Pa") = 1000"inlet pressure of A", CB(unit = "mol/m^3") = 55.6"Final concentration of B", fl(unit = "m^3 of liquid/ m^3 of total") = 0.9, kAg(unit = "mol/hr.m^2.Pa") = 0.0072, a(unit = "m^2/m^3") = 100, Vr(unit = "m^3") = 1.62"Volume of reactor", pi = 1e5, Fg(unit = "mol/hr") = 9000"gas flow rate", b = 1, Vl(unit = "m^3") = 1.62;
  
  equation
    MH1 = (DB * k * CB0)^0.5 / kAl;
  algorithm
    Ei1 := 1 + (CB0 * HA) / pAi;
    if Ei1 > MH1 then
      Ei1 := MH1;
    end if;
  equation
    -rA1 = pAi / ((pi * Vr / Fg) + (1 / (kAg * a)) + (HA / (kAl * a * Ei1)) + (HA / (k * CB0 * fl)));
    MH2 = (DB * k * CB)^0.5 / kAl;
  algorithm
    Ei2 := 1 + (CB * HA) / pAi;
    if Ei2 > MH2 then
      Ei2 := MH2;
    end if;
  equation
    -rA2 = pAi /  ((pi * Vr / Fg) + (1 / (kAg * a)) + (HA / (kAl * a * Ei2)) + (HA / (k * CB * fl)));
    -rA = (-rA1 +(-rA2)) / 2;
    t = (fl / b) * (CB0 - CB) / (-rA);
    tmin = (Vl * (CB0 - CB)) / (Fg * (pAi / (pi - pAi)));
    fract = (t - tmin) * 100 / tmin;
end Ex24_6;
