model Ex29_3
  Real N, tauopt(unit = "hr")"Optimum space time", vopt(unit = "m^3 / hr")"optimum volumetric flow", FA0(unit = "kg / hr")"Mass flow rate", XAopt, rmax(unit = "kg/hr")"Maximum consumption rate", FCmax(unit = "kg/hr")"maximum rate of Ecoli production", Ccopt;
  parameter  Real CA0(unit = "kg/m^3") = 6"initial concentration", CM(unit = "kg/m^3") = 0.4, k = 4, CbA = 0.1, V(unit = "m^3") = 1"Volume of reactor";
    
  equation
    N = (1 + (CA0 / CM))^0.5;
    k * tauopt = (N / (N - 1));
    vopt = V / tauopt;
    FA0 = vopt * CA0;
    rmax = FA0 * XAopt;
    XAopt = (N / (N + 1));
    FCmax = vopt * Ccopt;
    Ccopt = CbA * CA0 * (N / (N + 1));
end Ex29_3;