model Ex4_1
  // rxn: A + 3B --> 6R
  // 1-A, 2-B, 3-I, 4-R
  // concentration units are not given
  Real Cf[2] "final concentration", epsA"fractional change in volume of A", epsB"fractional change in volume of B", XA"Conversion of A", XB"Conversion of a B";
  parameter Real Ci[4] = {100, 200, 100, 0} "initial concentration", Ct[4] = {0, -100, 600, 100} "concentration for total conversion of A";
equation
  Cf[1] = 40;
//given in question
  epsA = (sum(Ct) - sum(Ci)) / sum(Ci);
  epsB = epsA * Ci[2] / (3 * Ci[1]);
  XA = (Ci[1] - Cf[1]) / (Ci[1] + epsA * Cf[1]);
  XB = 3 * Ci[1] * XA / Ci[2];
  Cf[2] = Ci[2] * ((1 - XB) / (1 + epsB * XB));
  
end Ex4_1;
