model Ex9_2
//simulate from 273 to 413 for 0 to 140 C, since temperature needs to be in K
// T is adjsted so that Temperature is shown on time scale
  Real T(unit = "K")"Temperature", Hr(unit = "J/mol")"Heat of reaction", K298"reaction rate constant at 298 K", K"Reaction rate constant at Ts ", X(min = 0, max = 1)"Conversion";
  parameter Real Ts(unit = "K") = 298"standard temperature", Hrs(unit = "J/mol") = -75300"standard heat of reaciton rate constant at Ts", Gs(unit = "J/mol")= -14130"standard gibbs free energy";
  constant Real R(unit = "J/mol.K") = 8.314"Gas constant";
  
  equation
    Hr = Hrs;//since change in Cp = 0
    K298 = exp(-Gs / (R * Ts));
    log(K / K298) = -(Hr / R) * (1/T - 1/Ts);
    X = K / (K + 1);
    T = time;
//part b can be solved using X vs time (i.e. Temperature) graph
end Ex9_2;
