package Ex10_1
  model a
    //simulate from 0 to 1
    //CA is adjusted so that it will decrease with time
    Real phiSA"Selectivity", CA(unit = "mol/liter") "concentration of CA", CS(unit = "mol/liter") "concentration of S";
    parameter Real k0 = 0.025, k1(unit = "min^-1") = 0.2, k2(unit = "liter/mol.min") = 0.4, CA0 = 1"initial concentration of CA";
  equation
    phiSA = k1 * CA / (k0 + k1 * CA + k2 * CA ^ 2);
    CA = CA0 - time;
    CS = phiSA * (CA0 - CA);
// take reading where slope of phiSA graph is zero
  end a;

  model b
    Real tau(unit = "min")"space time of MFR", V(unit = "liter")"Volume of one MFR", Vtotal(unit = "liter")"Total volume of reactors", rA(unit = "mol/(liter.min)")"Rate of consumption of A", v(unit = "liter/min")"volumetric flow rate for one MFR";
    parameter Real CA0(unit = "mol/liter") = 1"initial concentration of A", CA(unit = "mol/liter") = 0.25"optimum concentration of A", vtotal(unit = "liter/min") = 100"Volumetric flow rate of CA0", n = 4"no. of reactors", k0 = 0.025, k1(unit = "min^(-1)") = 0.2, k2(unit = "liter/(mol.min)") = 0.4;
    
    equation
      v = vtotal / n;
      tau = V / v;
      V = v * (CA0 - CA) / (-rA);
      -rA = k0 + k1 * CA + k2 * CA^2; 
      Vtotal = V * n;
        
  end b;
end Ex10_1;
