package Ex11_2
  model a
    Real Area1(unit = "gm.min/liter") "area calculated from material balance", Area2(unit = "gm.min/liter") "Area calculated from tracer curve", m(start = 1);
    parameter Real M(unit = "gm") = 150 "mass of the tracer", v(unit = "liter/s") = 5 "volumetric flow rate", A1(unit = "gm.min/liter") = 0.375;
  equation
    Area1 = M / (60 * v);
  algorithm
    for i in 1:5 loop
      Area2 := Area2 + A1 / m;
      m := m * 4;
    end for;
// if Area1 and Area2 are same, the experement done properly
  end a;

  model b
    Real tbar(unit = "min")"mean residence time", V(unit = "liters")"volume of liquid in tank", xl(unit = "%")"fraction of liquid", xv(unit = "%")"fraction of vapors", m(start = 4);
    parameter Real iCdt = 0.5, A1(unit = "gm.min/liter") = 0.375, v(unit = "liters/min") = 300, L(unit = "liters") = 860"Volume of tank";
    
    algorithm
      tbar := 2 * A1 / iCdt;
      for i in 2:4 loop
        tbar := tbar + (2 * i * A1 / m) / iCdt;
        m := m * 4;
      end for;
    equation
      V = tbar * v;
      xl = (V / L) * 100;
      xv = 100 - xl;
  //error is due to rounding off values
  end b;
end Ex11_2;
