model Ex12_1
  Real Vg(unit = "m^3")"Volume of Gas in contactor", Vl(unit = "m^3")"Volume of liquid in contactor", Vs(unit = "m^3")"stagnant volume in contactor", V(unit = "m^3")"available volume in contactor", pG"percentage of Gas", pL"percentage of liquid", pS"Percentage of stagnant", tg(unit = "s")"residence time of gas", tl(unit = "s")"residence time of liquid";
  parameter Real t1(unit = "s") = 6, t2(unit = "s") = 9, t3(unit = "s")  = 15, h(unit = "m") = 20"Height of contactor", A(unit = "m^2") = 1"cross sectional area of contactor", eps = 0.5"Voidage", vg(unit = "m^3/s") = 0.5"volumetric flow rate of Gas", vl(unit = "m^3/s") = 0.1"Volumetric flow rate of liquid";
  
  equation
    tg = (8 * (t2 - t1) + 11 * (t3 - t2)) / (t3 - t1);
    tl = 40;//from graph
    Vg = tg * vg;
    Vl = tl * vl;
    Vl + Vg + Vs = V;
    V = h * A * eps;
    pG = (Vg / V) * 100;
    pL = (Vl / V) * 100;
    pS = (Vs / V) * 100;
    
end Ex12_1;
