model Ex13_1
  Real tbar(unit = "min")"Mean residence time", var(unit = "min^2")"variance", vartheta, DbuL(start = 0.0001)"Dispersion number";
  parameter Real t[8](each unit = "min") = {0, 5, 10, 15, 20, 25, 30, 35}"Time", C[8](each unit = "gm/liter") = {0, 3, 5, 5, 4, 2, 1, 0}"Concentration";
  
  equation
    tbar = sum(t .* C) / sum(C);
    var = sum((t .* t) .* C) / sum(C) - tbar^2;
    vartheta = var / tbar^2;
    vartheta = 2 * DbuL - 2 * DbuL^2 * (1 - exp(-1 / DbuL));
    
     
end Ex13_1;
