package Ex18_1
  model a
    Real ratio "obs rate and film resistance control rate ratio";
    parameter Real rAobs(unit = "mol/(hr.m^3.cat)") = -10 ^ 5 "observed rate", dp(unit = "m") = 2.4e-3 "diameter of particle", CAg(unit = "mol/m^3") = 20 "Concentration of A", kg(unit = "m^3/(hr.m^2 cat)") = 300 "mass transfer coefficient";
  equation
    ratio = -rAobs * dp / (CAg * kg * 6);
// if ratio is small film resistance have not much significance and vice versa
  end a;

  model b
    Real Mw"Wagner Modulus";
    parameter Real rAobs(unit = "mol/(hr.m^3 cat)") = -10^5"Observed rate", L(unit = "m of cat") = 4e-4, De(unit = "m^3/(hr.mcat.K)") = 5e-5"Effective mass conductivity", CAg(unit = "mol/m^3") = 20"Concentration of A";
    
    equation
      Mw = (-rAobs * L^2) / (De * CAg); 
  // if Mw is greater than 4, pore diffusion will influence and slow don rate of reaction
  end b;

  model c
    Real delTmaxp(unit = "C")"max temp diff between pallete", delTmaxf(unit = "C")"max temp diff between film";
    parameter Real De(unit = "m^3 /(hr.m cat)") = 5e-5"effective mass conductivity", CAg(unit = "mol/m^3") = 20"Concentration of A", Hr(unit = "kJ/mol A") = -160"Heat of reaction", keff(unit = "kJ/(hr.m cat.K)") = 1.6"effective thermal conductivity", L(unit = "m cat") = 4e-4, rAobs(unit = "mol/(hr.m^3 cat)") = -10^5"Observed rate" , h(unit = "kJ/(hr.m^2 cat)") = 160"Heat transfer coefficient";
    
    equation
      delTmaxp = De * (CAg - 0) * (-Hr) / keff;
      delTmaxf = L * (-rAobs) * (-Hr) /  h;
  end c;
end Ex18_1;
