package Ex20_1
  model preliminery
    // this is for checking assumptions
    Real ratio "ub/umf", ub(unit = "m/s"), ubr(unit = "m/s"), uf(unit = "m/s");
    parameter Real g(unit = "m/s^2") = 9.8 "gravitational acceleration", d(unit = "m") = 0.32 "diameter of the bubble", u0(unit = "m/s") = 0.3, epsmf = 0.5, umf(unit = "m/s") = 0.03;
  equation
    ubr = 0.711 * (g * d) ^ 0.5;
    ub = u0 - umf + ubr;
    ratio = ub / uf;
    uf = umf / epsmf;
//ratio shows relative velocity of bubble rising w.r.t. emulsion
  end preliminery;

  model a
    Real del(unit = "m^3 bubbles/ m^3 bed"), epsf, Kbc(unit = "s^-1")"(Interchange volume/s)/volume of bubble", Kce(unit = "s^-1")"(interchange volume/s)/volume of bubble", fb"Volume of solids/volume of bed", fc"Volume of solids in cloud or wake/volume of bed", fe"Volume of solids in the rest of the emulsion/volume of bed", HBFB(unit = "m"), CA(unit = "mol/m^3")"Concentration of A", XA"Conversion of A";
    parameter Real CA0(unit = "mol/m^3") = 100"initial concentration of A", D(unit = "m^3/s") = 20e-6"Diffusion coeff", alpha = 0.33, db(unit = "m") = 0.32"diameter of bubble", epsmf = 0.5, W(unit = "kg") = 7000"weight of bed", rhos(unit = "kg/m^3") = 2000"density of bed", umf(unit = "m/s") = 0.03, k = 0.8"reaction rate constant", u0(unit = "m/s") = 0.3, ub(unit = "m/s") = 1.53, ubr(unit = "m/s") = 1.26, g(unit = "m/s") = 9.8"gravitational acceleration";
    
    equation
      del = u0 / ub;
      epsf = 1 - (1 - epsmf)*(1 - del);
      Kbc = 4.5 * (umf / db) + 5.85 * (D^0.5 * g^0.25 / db^(5/4));
      Kce = 6.77 * (epsmf * D * ubr / db^3)^0.5;
      fb = 0.001;
      fc = 0.196 * (1 - epsmf) * ((3 * umf / epsmf) / (ubr - umf/epsmf) + alpha);
      fb + fc + fe = (1 - epsf);
      HBFB = W / (rhos * 3.14 * (1 - epsf));
      log(CA0 / CA) = ((fb * k + (1 / ((1 / (del * Kbc)) + (1 / (fc * k + (1 / ((1 / (del * Kce)) + (1 / (fe * k)))))))) )/ (fb + fc + fe)) * (HBFB * (1 - epsf) / u0);
      XA = 1 - CA / CA0;
      
  end a;

  model b
    Real CAbar(unit = "mol/m^3")"Concentration of A seen by solids";
    parameter Real CA0(unit = "mol/m^3") = 100"initial concentration of A", CA(unit = "mol/m^3") = 68" Final concentration of A", k = 0.8"Reaction rate constant", v0bVs = 0.3 * 3.14 / 3.5;
    
    equation
      CAbar = (CA0 - CA) * v0bVs / k;
  end b;

  model c
    Real XA(unit = "%")"percent conversion of A", CAp(unit = "mol/m^3")"final concentration in fixed bed reactor";
    parameter Real k(unit = "s^(-1)") = 0.8"Reaction rate constant", tau(unit = "s") = 3.715"space time", CA0(unit = "mol/m^3") = 100"initial concentration of A";
    
    equation
      log(CA0/CAp) = k * tau;
      XA = (1 - (CAp / CA0)) * 100;
  end c;
end Ex20_1;
