package Ex21_2
  model CA0
    Real CA0(unit = "mol/m^3") "initial concentration of A";
    parameter Real pA0(unit = "atm") = 3 "initial Pressure of A", T(unit = "K") = 730 "temperature";
    constant Real R(unit = "m^3. atm/mol.K") = 82.06e-6;
  equation
    CA0 = pA0 / (R * T);
  end CA0;

  model a
  //simulate from 0 to 10368000 
  // see time in day scale
  //see XA from graph
    Real XA"conversion of A", a(start = 1);
    parameter Real dadt(unit = "sec^(-1)") = -8.3125e-3/(24 * 3600);
    
    equation
      XA = 100 * a / (1 + 100 * a);
      der(a) = dadt;
  end a;

  model b
  //simulate from 0 to 10368000 
  // see time in day scale
  //see XA from graph
    Real XA"conversion of A", a(start = 1);
    parameter Real m = 0.05/(24 * 3600);
    
    
    equation
      XA = 100 * a / (1 + 100 * a);
      der(a)  = (-a) * m;
  end b;

  model c
  //simulate from 0 to 10368000 
  // see time in day scale
  //see XA from graph
    Real XA"Conversion of A", a(start = 1);
    parameter Real m = 3.325 / (24 * 3600);
    
    equation
      XA = 100 * a / (1 + 100 * a);
      der(a)  = - m * a^2;
  end c;

  model d
  //simulate from 0 to 10368000 
  // see time in day scale
  //see XA from graph
    Real XA"conversion of A", a(start = 1);
    parameter Real m = 666.5 / (24 * 3600);
      
    equation
      XA = 100 * a / (1 + 100 * a);
      der(a)  = - m * a^3;
  end d;
end Ex21_2;
