model Ex22_2
//simulate from 0 to 2250
  Real CA(unit = "mol/m^3 l")"concentration of A", ac(unit = "m^2 cat/m^3 l"), Mt"Thiele Modulus", rA(unit = "mol/m^3 l.s")"rate of conversion of A", epsA, CB(unit = "mol / m^3 l")"concentration of B", t(unit = "s")"time", recrA"1 / -rA";
  parameter Real CB0(unit = "mol/m^3 l") = 2500"initial concentration of B", CBf(unit = "mol/m^3 l") = 250"final concentration of B", PA(unit = "Pa") = 14.6 * 101325"pressure", HA = 148000, fs = 0.0055, dp(unit = "m") = 5e-5"diameter of pores", kAc = 4.4e-4, L = (5e-5 /6), rhos(unit = "kg/m^3") = 1450"density of solid", De(unit = "m^3 l/m cat.s") = 5e-10"diffusion constant", kAiai = 0.277, k  = 5e-5"rate constant";
   
   equation
    CA = PA / HA;
    ac = 6 * fs / dp;
    rA = (1 / ((1 / kAiai) + (1 / (kAc * ac)) + 1 / (k * CB * rhos * epsA * fs))) * (PA / HA);
    der(t) / der(CB) = 1 / (rA);//reduced from eqn 12
    CB = CB0 - time;
    //Mt = L * (k * CB * rhos / De)^0.5; 
    Mt = 0.1 * CB^0.5;
    epsA = 1 / Mt;
    recrA = (1 / (rA));
// answer may vary due to rounding off values of Mt during calculation of epsA in book  
end Ex22_2;
