model Ex26_1
  Real XB"Overall conversion", XB50"Conversion of 50 um pariticles", XB100"Conversion of 100 um particles", XB200"Conversion of 200 um particles";
  parameter Real t(unit = "min") = 8, tau50(unit = "min") = 5"complete conversion time for 50 um particles", tau100(unit = "min") = 10"complete conversion time for 100 um particles", tau200(unit = "min") = 20"complete conversion time for 200 um particles", xF50 = 0.3"fraction of 50 um particles in feed", xF100 = 0.4"fraction of 100 um particles in feed", xF200 = 0.3"fraction of 200 um particles in feed";
  
  equation
    (1 - XB) = (1 - XB50) * xF50 + (1 - XB100) * xF100 + (1 - XB200) * xF200;
    (1 - XB50) = 0; //since tua50 < t
    (1 - XB100) = (1 - t/tau100)^3;
    (1 - XB200) = (1 - t/tau200)^3;
end Ex26_1;