package Ex3_4
  model a
    // at 400 K -rA = 2.3 * pA^2
    // at 500 K -rA = 2.3 * pA^2
    Real E;
    parameter Real k1(unit = "mol.atm^2/(m^3.s)") = 2.3"Reaction rate constant at T1", k2(unit = "mol.atm^2/(m^3.s)") = 2.3"Reaction rate constant at T2", T1(unit = "K") = 400"Initial temperature", T2(unit = "K") = 500"Final temperature";
    constant Real R(unit = "J/mol.K") = 8.314;
  equation
    log(k1 / k2) = E / R * (1 / T1 - 1 / T2);
  end a;

  model b
    Real k1(unit = "m^3/mol.s")"Reaction rate constant at T1", k2(unit = "m^3/mol.s")"Reaction rate constant at T2", E(unit = "J/mol") "activation energy";
    parameter Real T1(unit = "K") = 400 "initial temperature", T2(unit = "K") = 500 "final temperature";
    constant Real R = 8.314;
  equation
    k1 = 2.3 * (82.06 * 10 ^ (-6)) ^ 2 * T1 ^ 2;
    k2 = 2.3 * (82.06 * 10 ^ (-6)) ^ 2 * T2 ^ 2;
    E / R * (1 / T1 - 1 / T2) = log(k2 / k1);
  end b;
end Ex3_4;
