model Ex30_1
  Real mCRs(unit = "kg/m^3")"concentation of R", CRopt(unit = "kg/m^3")"optimum concentration of R", tauwash(unit = "hr"), tauopt(unit = "hr"), vopt(unit = "m^3/hr")"optimum volumetric flow rate", FR(unit = "kg alc/hr");
  parameter Real k(unit = "hr^-1") = 3^0.5, CRs(unit = "kg alc/kg solution") = 0.12, rho(unit = "kg/m^3") = 1000"density", V(unit = "m^3") = 30"Volume of reactor";
  
  equation
    mCRs = CRs * rho;
    CRopt = mCRs / 2;
    k * tauwash = 1;
    tauopt = 2 * tauwash;
    vopt = V / tauopt;
    FR = vopt * CRopt;
end Ex30_1;