model Ex5_4
  //put interval as 0 to 0.8 and then simulate
  // get answer from graph at time = 0.8
  // rxn: A --> 3R
  
  Real XA(start = 0 "Conversion"), epsA "expansion factor", tau(unit = "sec") "time constant", rA(unit = "mol/lit.sec");
  parameter Real CA0(unit = "mol/lit") = 0.0625 "initial concentration", k = 0.01 "reaction rate constant", a = 1, r = 3, i = 1;
equation
  epsA = (r + i - (a + i)) / (a + i);
  der(tau)/ der(XA) = CA0 * (1 / (-rA));
  -rA = k * CA0 ^ 0.5 * ((1 - XA) / (1 + epsA * XA)) ^ 0.5;
  der(XA) = 1;
end Ex5_4;
