model Ex1_1
  // rxn: H2 + 0.5O2 --> H2O
  Real V(unit = "m^3") "Reactor volume", nH2O(unit = "kmol/s") "rate of H2O produced", nH2(unit = "kmol/s") "rate of H2 usex", nO2(unit = "kmol/s") "rate of O2 used", rH2(unit = "mol/m^3.s"), rO2(unit = "mol/m^3.s");
  parameter Real l(unit = "m") = 0.75 "length of reactor", d(unit = "m") = 0.6 "diameter of reactor", mwH2O = 18 "molecular weight of H2O", mwH2 = 2 "molecular weight of H2", mwO2 = 16 "molecular weight of O2", rE(unit = "kg/s") = 108 "rate of exhaust gas";
  constant Real pi = 3.14;
equation
  V = pi / 4 * d ^ 2 * l;
  nH2O = rE / mwH2O;
  nH2 = nH2O;
  nO2 = 0.5 * nH2O;
  -rH2 = -1 / V * nH2 * 10 ^ 3;
  -rO2 = (-1 / V) * nO2 * 10 ^ 3;
end Ex1_1;
