model Ex1_2
  // rxn: C6H12O6 + 6O2 --> 6CO2 + 6H2O
  Real rO2(unit = "mol O2 used/ m^3.s"), dnO2(unit = "moles of O2/day") "moles of O2 consumed per day", V(unit = "m^3") "volume of kone human";
  parameter Real den(unit = "kg/m^3") = 1000 "density", m(unit = "kg") = 75 "mass", EC(unit = "kJ/day") = 6000 "energy consumed per day", Hr(unit = "kJ") = 2816 "";
equation
  V = m / den;
  dnO2 = EC / Hr * 6;
  -rO2 = -1 / V * dnO2 / (24 * 3600);
end Ex1_2;