model Ex19_1
  Real slope"slope of adiabatic curve", W(unit = "kg")"weight of the bed", Q1(unit = "Watt")"Heat added to feed", Q2(unit = "Watt")"Heat removed from product";
  parameter Real Cp(unit = "J/mol.K") = 40"specific heat", nF = 8"no of atoms in feed", XA = 0.8"Conversion of A", R = 1"Recycle ratio from fig 19.1b", Hr(unit = "J/mol") = -80000"Heat of Reaction", FA0(unit = "mol/sec") = 100"flow rate of feed", Tf(unit = "K") = 300"Temperature of feed", Ti(unit = "K") = 600"Inlet temperature of reactor", To(unit = "K") = 800"Outlet temperature of Reactor";
  
  equation
    slope = nF * Cp / (-Hr);
    (W / FA0) = XA * (6 * nF);
    Q1 = nF * FA0 * Cp * (Ti - Tf);
    Q2 = nF * FA0 * Cp * (Tf - To);
end Ex19_1;
