model Ex24_3
//simulate for 20 to 100
  Real CB2(unit = "mol/m^3")"final concentration of B", rA(unit = "mol/m^3 reactor.hr")"rate of production of A", h(unit = "m")"Height of tower", PA(unit = "Pa")"Pressure of A", CB(unit = "mol/m^3")"Concentration of B";
  parameter Real HA(unit = "Pa.m^3/mol") = 12.5, PA1(unit = "Pa") = 20"Initial pressure of A", PA2(unit = "Pa") = 100"Final pressure of A", CB1(unit = "mol/m^3") = 32"Initial concentration of B", kAg = 0.32, kl = 0.1, FgbAcs(unit = "mol/hr.m^2") = 1e5, pi = 1e5, a = 1"stoichiometric coeff of A";
  
  equation
    PA2 = 420 - 12.5 * CB2;
    rA = (HA * CB1 + PA1) / ((1 / (kAg * a)) + (HA / (kl * a))) ;
    PA = 420 - 12.5 * CB;
    der(h)/der(PA) = (FgbAcs / pi) * (1 / (rA)) ;
    PA = time;
//see height for time = 100
end Ex24_3;
