model Ex26_3
  Real t(unit = "min"), r50"tau50 / t", r100"tau100 / t", r200"tau200 / t", F50(unit = "gm/min")"feed flow rate for 50 um particles", F100(unit = "gm/min")"Feed flow rate for 100 um particles", F200(unit = "gm/min")"Feed flow rate for 200 um particles", XB"Conversion of B";
  parameter Real F(unit = "gm/min") = 1000"Feed flow rate", W(unit = "gm") = 10000"Mass of bed", xF50 = 0.3"fraction of 50 um particles in feed", xF100 = 0.4"fraction of 100 um particles in feed", xF200 = 0.3"fraction of 200 um particles in feed", tau50(unit = "min") = 5"complete conversion time for 50 um particles", tau100(unit = "min") = 10"complete conversion time for 100 um particles", tau200(unit = "min") = 20"complete conversion time for 200 um particles";
  
  equation
    F50 = F * xF50;
    F100 = F * xF100;
    F200 = F * xF200;
    t = W / F;
    r50 = tau50 / t;
    r100 = tau100 / t;
    r200 = tau200 / t;
    1 - XB = ((1 / 4) * r50 - (1 / 20) * r50^2) * xF50 + ((1 / 4) * r100 - (1 / 20) * r100^2) * xF100 + ((1 / 4) * r200 - (1 / 20) * r200^2) * xF200;
// error is due to rounding off values
end Ex26_3;