model Ex5_1
  // rxn : A + B --> C
  Real tau(unit = "min")"Residence time", rA(unit = "mol/lit.min"), rB(unit = "mol/lit.min"), rC(unit = "mol/lit.min");
  parameter Real Ci[3](each unit = "mol/lit") = {0.1, 0.01, 0} "initial concentration", Cf[3](each unit = "mol/lit") = {0.02, 0.03, 0.04} "final concentration", V(unit = "lit") = 1 "volume of reactor", v(unit = "lit/min") = 1 "volumetric flow rate";
equation
  tau = V / v;
  -rA = (Cf[1] - Ci[1]) / tau;
  -rB = (Cf[2] - Ci[2]) / tau;
  -rC = (Cf[3] - Ci[3]) / tau;
end Ex5_1;
