model Ex5_2
  // rxn: 2A --> R
  Real epsA "expansion factor", XA[4] "conversion", rA[4](each unit = "millimol/liter.hr"), k(start = 0.1)"Reaction Rate constant", n"Order of Reaction";
  parameter Real CAf[4](each unit = "millimol/liter") = {85.7, 66.7, 50, 33.4} "final concentration of A", CA0(unit = "millimol/liter") = 100, v0[4](each unit = "liter/hr") = {10, 3, 1.2, 0.5} "volumetric flow rate", V(unit = "liter") = 0.1 "volume of reactor", a = 2 "stoichiometric coeff of A", r = 1 "stoichiometric coeff of R";
equation
  epsA = (r - a) / a;
  XA = (1 .- CAf / CA0) ./ (1 .+ epsA * CAf / CA0);
  rA = CA0 * (v0 .* XA) / V;
  for i in 1:2 loop
    log10(rA[i]) = log10(k) + n * log10(CAf[i]);
  end for;
//since we are only considering two points this is approximate solution
end Ex5_2;
