model Ex5_3
  // A + 2B <==> R
  //1-A, 2-B, 3-R
  Real Cf[3](each unit = "mol/liter") "final concentration", rB(unit = "mol/lit.min"), rA(unit = "mol/lit.min"), v(unit = "liter/min") "volumetric flow in reactor", tau(unit = "min")"Residence time of reactor";
  parameter Real Ci[3](each unit = "mol/liter") = {1.4, 0.8, 0} "initial concentration", V(unit = "liter") = 6 "volume of reactor", XB = 0.75 "conversion of B", a = 1 "stoichimetric coeff of A", b = 2 "stoichiometric coeff of B", r = 1 "stoichiometric coeff of R", k1 = 12.5 "forward reaction rate constant", k2 = 1.5 "backward reaction rate constant";
equation
  Cf[2] = Ci[2] * (1 - XB);
  Cf[1] = Ci[1] - (Ci[2] - Cf[2]) * a / b;
  Cf[3] = Ci[3] + (Ci[2] - Cf[2]) * r / b;
  rA = k1 * Cf[1] * Cf[2] ^ 2 - k2 * Cf[3];
  rB = 2 * (rA);
  tau = V / v;
  v = V * (rB) / Cf[2];
end Ex5_3;
